sbit       NumLock_LED    =    P4^1;
sbit       Caps_LED       =    P4^2;
sbit       ScrollLock_LED =    P4^0;

#define    MAX_COLUMN          0x12
#define    MAX_ROW             0x08

#define    L_CTRL              0xE0
#define    L_SHIFT             0xE1
#define    L_ALT               0xE2
#define    L_GUI               0xE3
#define    R_CTRL              0xE4
#define    R_SHIFT             0xE5
#define    R_ALT               0xE6
#define    R_GUI               0xE7

#define    VOLUMEUP_KEY        0x01
#define    VOLUMEDOWN_KEY      0x02
#define    VOLUMEMUTE_KEY      0x03

#define    KEYPLAYPAUSE_KEY    0x04
#define    KEYNEXT_KEY         0x05
#define    KEYPREVIOUS_KEY     0x06
#define    KEYSTOP_KEY         0x07
#define    KEYMEDIAPLAY_KEY    0x08

#define    KEYSEARCH_KEY       0x09
#define    KEYEMAIL_KEY        0x0A
#define    KEYWWW_KEY          0x0B

#define    KEYSLEEP_KEY        0x0C
#define    KEYPOWER_KEY        0x0D
#define    KEYWAKEUP_KEY       0x0E


typedef struct
   { BYTE Column;
     BYTE Code;
     BYTE Tmp;
     BYTE Store[MAX_COLUMN];
   } SCAN;


typedef struct
   { BYTE Busy;
     BYTE IdleRate;
     BYTE Protocol;
     BYTE Index;
     BYTE Code;
     BYTE GhostFlag;
     BYTE ChangeFlag;
   } KEY;


typedef struct
   { BYTE Busy;
     BYTE ChangeFlag;
     BYTE Key;
     BYTE Code[2];
   } M_KEY;                                      // MultiMedia Key


typedef struct
   { BYTE LeftCtrl : 1;
     BYTE LeftShift : 1;
     BYTE LeftAlt : 1;
     BYTE LeftGui : 1;
     BYTE RightCtrl : 1;
     BYTE RightShift : 1;
     BYTE RightAlt : 1;
     BYTE RightGui : 1;
   } MODIFIER;


typedef struct
   { MODIFIER Modifier;
     BYTE Reserve;
     BYTE Code[6];
   } PART;


typedef union	// allow bit or byte access to registers 
   { PART Part;
     BYTE Code[8];
   } TOHOST;


typedef struct
   { BYTE Act;
     SCAN Scan;
     KEY Key;
     M_KEY M_KB;                                 // MultiMedia Key
     BYTE HostIndex;
     TOHOST ToHost;
     BYTE i;
     BYTE Tmp;
   } KEYBOARD;